
#ifndef MOVGEN_H
# define MOVGEN_H

typedef struct{
	double x;		//position
	double vel;		//velocity
	double acc;		//acceleration
	double target_pos;	//target position
	double max_vel;		//max velocity
	BYTE state;		//current state
}Axis;

//Axis states
#define IDLE	0
#define BUSY	1


//Single axis ramp generation
void ramp_gen_tpos(Axis *a);
void start_move(Axis*a, double target_pos, double acc, double mvel);

//Combined 3-axis synchronized move generation
void start_lin_move(Axis*ax, Axis*ay, Axis*az, double feed);
BOOL lin_move_gen(Axis*ax, Axis*ay, Axis*az);
BOOL lin_mov_avail();
void stop_lin_move();

#endif	//MOVGEN_H
