import mikrocnc as mcnc
import gcode
import random as rand
import math

print('*** Bouncer demo ***')

def hpresek(x,y,M,k):
    n=y-k*x
    return (M-n)/k, M
    
def vpresek(x,y,M,k):
    n=y-k*x
    return M, k*M+n
    
def unutra(x,y) -> bool:
    return x>=xmin and x<=xmax and y>=ymin and y<=ymax

def moze(x,y,nx,ny) -> bool:
    #return unutra(nx,ny) and (x!=nx or y!=ny)
    return unutra(nx,ny) and ((not fequ(x,nx)) or (not fequ(y,ny)))

def fequ(x,y):
    return abs(x-y)<1e-8

feed = 4000.
xmax = ymax = 100.
xmin = ymin = 0.

x,y = xmin,ymin
k=0.25
wall = ''

print(f'Bouncing in rectangle ({xmin}, {ymin}, {xmax}, {ymax})')
print('Press STOP to end')

while (True):

    while(mcnc.IsMoveBusy()):
        continue
    
    print(f"Add move to the {wall} ({x:.2f}, {y:.2f})...")    
    mcnc.LinearMove(feed,x,y)
    
    
    nx,ny = hpresek(x,y,ymax,k)
    
    if moze(x,y,nx,ny): 
        x,y=nx,ny
        wall = 'top'
        
    else:
        nx,ny = hpresek(x,y,ymin,k)
        
        if moze(x,y,nx,ny):
            x,y=nx,ny
            wall = 'bottom'
            
        else:
            nx,ny = vpresek(x,y,xmin,k)
            
            if moze(x,y,nx,ny):
                x,y=nx,ny
                wall = 'left'
                
            else:
                nx,ny = vpresek(x,y,xmax,k)
                x,y = nx,ny
                wall = 'right'
     
    #k=-1/k
    k=10.*(rand.random()-0.5)          # random reflection
    #k=math.tan(3.1459-math.atan(k))    # incoming angle equal to the outgoing angle
    if k==0.: k=0.5
    
    #print("k=",k)
  
   