import mikrocnc as mcnc
import gcode

def goto_point(feed,x, y):
    while (mcnc.IsMoveBusy()):
        continue
    mcnc.LinearMove(feed, x, y)


print('*** LinearMove test script started ***')

feed = 2000.
stx, sty = 0.,0.
endx, endy = 100., 100.


for i in range(3):
    print('feedrate=', feed)
    print('Add move forward...')
    goto_point(feed, stx, sty)
    
    print('Add move reverse...\n')
    goto_point(feed, endx, endy)
    
    feed = feed+1000
    
while (mcnc.IsMoveBusy()):
        continue
        
print('Back to home...')
mcnc.LinearMove( -1, 0.,0.)  #rapid move

mcnc.WaitIdle()


print('Finished.')

            

    
    
        