import gui
import mikrocnc as mcnc
import fileio as fio
import gcode
import math

###### This macro demonstrates using user interface dialog box for user input ########

#function to fetch parameters from dialog and generate g-code
#called when Generate button is clicked

def on_generate():
    d.UpdateData()  #fetch all variables
    try:
        star = bool(d.GetValue('rad2'))
        corners = int(d.GetValue('edit1'))
        radius = float(d.GetValue('edit2'))
        radius2 = float(d.GetValue('edit3'))
        rota = float(d.GetValue('edit4'))
    except:
        #print('That is not a valid nunmber!')
        mcnc.MessageBox(mcnc.MB_OK, 'Error: invalid data entered')
        return
    
    if corners<3:
        mcnc.MessageBox(mcnc.MB_OK, 'Number of coreners should be at least 3')
        return
    if radius<=0 or radius2<=0:
        mcnc.MessageBox(mcnc.MB_OK, 'Radius should be a positive number')
        return
        
    step = 360./corners
    print('Star=', star)
    print('Corners=',corners)
    print('Radius=',radius)
    print('Radius2=',radius2)
    print('Rotate=',rota)
    
    rota = rota/180.*math.pi    #convert to radians
    
    with fio.open('mygcode.tap','w') as file:
        file.writeline('F500S8000\n')
        file.writeline('G0Z10\n')
        file.writeline(f'G15G90G0X{radius*math.cos(rota):.4f}Y{radius*math.sin(rota):.4f}\n')
        file.writeline('M3G1Z0\n')
        
        file.writeline('G16G91\n')
        
        for i in range(corners):
            if(star):
                file.writeline(f'G1Y{step/2:.4f}x{-radius+radius2:.4f}\n')
                file.writeline(f'G1Y{step/2:.4f}x{radius-radius2:.4f}\n')
            else:
                file.writeline(f'G1Y{step:.4f}\n')
                
        file.writeline('M5G15G90\n')
	
    gcode.LoadFile(mcnc.GetMacroPath()+'mygcode.tap')
    print('Generate finished.')

#callback click on Polygon radio button
def on_poly():
    d.EnableItem('edit3', False)
    
#callback click on Star radio button
def on_star():
    d.EnableItem('edit3', True)

##### create dialog box ####

d = gui.DialogBox(145,165,"Generate polygon")

d.AddText(label='Object to generate:')
d.AddRadio(x=12, name='rad1', label='Polygon', default_val=True, callback='on_poly')
d.AddRadio(x=12, name='rad2', label='Star', callback='on_star')

d.AddText(w=40,label='Corners:',offy=3)
d.AddEdit(w=50,name='edit1', align=gui.LEFTPREV, default_val='6')

d.AddText(w=40,label='Radius:')
d.AddEdit(w=50,name='edit2', align=gui.LEFTPREV, default_val='100')
d.AddText(label='mm',align=gui.LEFTPREV)

d.AddText(w=40,label='Radius2:')
d.AddEdit(w=50,name='edit3', align=gui.LEFTPREV, default_val='50')
d.AddText(label='mm',align=gui.LEFTPREV)
d.EnableItem('edit3',False)

d.AddText(w=40,label='Rotate:')
d.AddEdit(w=50,name='edit4', align=gui.LEFTPREV, default_val='0')
d.AddText(label='degrees',align=gui.LEFTPREV)

d.AddButton(h=20, w=45, offy=1, name='gener',label='Generate',align=gui.CENTER, callback='on_generate')

d.AddButton(y=165-20, w=50,name='IDOK',label='Exit',align=gui.CENTER)

d.SetDefaultButton('gener')
d.SetMargins(6,2)
ret = d.DoModal()

d.Delete()


