import gui
import mikrocnc as mcnc


###### This macro demonstrates using user interface dialog box for user input ########

#few variables to edit
var1 = 123
var2 = 456

##### create dialog box ####

d = gui.DialogBox(150,100,'Enter variable values')

d.AddText(w=40,label='Variable1:')   #add label text
d.AddEdit(w=50,name='edit1', align=gui.LEFTPREV, default_val=str(var1))    #add edit field that follows

d.AddText(w=40,label='Variable2:')   #add label text
d.AddEdit(w=50,name='edit2', align=gui.LEFTPREV, default_val=str(var2))    #add edit field that follows

d.AddButton(y=100-20, w=50, name='IDOK',label='OK',align=gui.CENTER)

d.SetMargins(5,5)  #optional setup
ret = d.DoModal()   #show dialog and run dialog modal loop

#when OK button is pressed fetch edited variable values

if ret==1:
 var1 = int(d.GetValue('edit1'))
 var2 = int(d.GetValue('edit2'))
 print('var1=',var1,' var2=',var2)
 
d.Delete()  #delete is optional here since all resources are released when script finishes


