import mikrocnc as mcnc
import InputSignal as inp


print('*** Testing manual JogOn/JogOff ***' )
print('Using signals INPUT1 and INPUT2 to control X axis Jog')
print('INPUT1 and INPUT2 signals should be enabled and configured')
print('\nPress STOP button for finish.')

#set continuous Jog mode
mcnc.SetJogMode(0)

axis = 0    #move X axis
speed = 50  #speed is 50%

in1last = inp.GetState(inp.INPUT1)
in2last = inp.GetState(inp.INPUT2)

while True: #create endless loop

    in1 = inp.GetState(inp.INPUT1)
    if in1 != in1last : #INPUT1 changed state?
        if in1: mcnc.JogOn(axis, 0, speed)  #new state is active
        else : mcnc.JogOff(axis)    #new state is inactive
        in1last = in1
        
    in2 = inp.GetState(inp.INPUT2)
    if in2 != in2last : #INPUT2 changed state?
        if in2: mcnc.JogOn(axis, 1, speed)  #new state is active
        else : mcnc.JogOff(axis)    #new state is inactive
        in2last = in2
        
    mcnc.Sleep(10)  #save some CPU cycles
