import mikrocnc as mcnc
import OutputSignal as out

### This script is running in background continuously when machine is enabled   ###
# You should be very careful what operations you perform inside the script to     #
# avoid any possible conflicts with other running tasks.                          #
# Preferably, NO movement commands should be called.                              #
# Inserting waiting function (Sleep) in the loop helps to minimize CPU load.      #
### (To use this script enable it in Setup/Button scripts section )             ###

# this example is demonstrating reading keyboard using GetKeyState() function and
# controlling some output signals and spindle
# button press/release actions are recognized by comparing current key state with the last state
# also CTRL and SHIFT modifiers are used to recognize CTRL+key or SHIFT+key combinations
# Namely:
# F2 key controls OUTPUT1 directly
# CTRL+F3 toggles state of the OUTPUT2
# SHIFT+F3 toggles spindle run state

#define key codes
VK_F2 = 0x71
VK_F3 = 0x72
VK_CTRL = 0x11
VK_SHIFT = 0x10

#define output signals to control
OUT1 = out.OUTPUT1
OUT2 = out.OUTPUT2

#init last states
lk1,lk2 =0,0
state=False

def IsKeyDown(vkey):
	return 0!=(mcnc.GetKeyState(vkey) & 0x8000)

while True:	#create endless loop
	
	k1 = IsKeyDown(VK_F2)
	k2 = IsKeyDown(VK_F3)
	ctrl = IsKeyDown(VK_CTRL)
	shift = IsKeyDown(VK_SHIFT)
	
	if k1 and not lk1:  #button pressed
		print('Set')
		out.SetState(OUT1, True)
        
	if not k1 and lk1:  #button released
		print('Reset')
		out.SetState(OUT1, False)
		
	if k2 and not lk2:	#button pressed
		if ctrl:
			state=not state
			print('Toggle')
			out.SetState(OUT2, state)
		elif shift:
            print('Spindle start/stop')
			s = mcnc.GetSpindleState()
			if s: mcnc.SpindleStop()
			else: mcnc.SpindleStartCW()
		
	lk1 = k1
	lk2 = k2
	
	mcnc.Sleep(50)

