import mikrocnc as mcnc
import gcode
import fileio as fio
import math

#***** Example macro to generate g-code file and load it ******

print('*** Generate G-code ***')

H=100   #mesh height
W=100   #mesh width

with fio.open('mygcode.tap','w') as file:
    file.writeline('G1F500\n')
    j=i=0
    stepx=1
    dmax = math.sqrt(W*W/4.+H*H/4.)
    
    for k in range(H+1):
        for f in range(W+1):
            x = (i-W/2.)
            y = (j-H/2.)
            d = math.sqrt(x*x+y*y)
            z = 0.1*(dmax-d)*2*math.sin(0.5*d)
            file.writeline(f'X{x}Y{y}Z{z}\n')
            if(stepx>0 and i<W) or (stepx<0 and i>0): i=i+stepx
            else: j=j+1

        stepx=-stepx

               
gcode.LoadFile(mcnc.GetMacroPath()+'mygcode.tap')

print('Finished.')

    