import gcode
import mikrocnc as mcnc
import fileio as fio
import math
import sys # needed for input parameters

# L -> number of columns in a matrix
# P -> number of rows in a matrix
# Q -> x dimension of one block
# R -> y dimension of one block

#global parameters
xoffset = -33.5
yoffset = -42
feedrate = 700
laserOn = " A0.255\n"
laserOff = " A0.000\n"


# here we store the input parameters of the macro in local variables 
cntx = int(sys.argv[1]) 
cnty = int(sys.argv[2])
sx = int(sys.argv[3])
sy = int(sys.argv[4])


# create a file with custom gcode 
with fio.open('laser_test.tap','w') as file:
    
    xlength = cntx*sx
    ylength = cnty*sy
    
    # setup
    file.writeline('G90\n')
    file.writeline('M3 S10000\n')
    file.writeline(f'G0X{xoffset}Y{yoffset}' + laserOff)
    file.writeline(f'G1F{feedrate}\n')
    
    # trace horizontal lines
    file.writeline(f'G1X{xoffset+xlength}' + laserOn)
    for xLine in range(cnty):
        file.writeline(f'G0Y{yoffset+sy*(xLine+1)}' + laserOff)
    
        file.writeline(f'G1X{xoffset+xlength*((xLine)%2)}' + laserOn)
    
    # trace vertical lines
    invert = 1
    if(cnty%2):
        invert = 0
    file.writeline(f'G1Y{yoffset}' + laserOn)
    for yLine in range(cntx):
        if(invert):
            file.writeline(f'G0X{xoffset+sx*(cntx-1-yLine)}' + laserOff)
        else:
            file.writeline(f'G0X{xoffset+sx*(yLine+1)}' + laserOff)

        file.writeline(f'G1Y{yoffset+ylength*((yLine+1)%2)}' + laserOn)
    
    # final part
    file.writeline(f'G0X0Y0' + laserOff)
    file.writeline('M5\n')
    file.writeline('M30\n')
    
# Write success message in Macro log window
print("Script built successfully")

# load the gcode file into mikroCNC environment
gcode.LoadFile(mcnc.GetMacroPath()+'laser_test.tap')